/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include "metypes.h"
#include "mem_address.h"
#include "m4vdec_api.h"
#include "mbx_command.h"

#define ARM2DSP1		0xF800
#define ARM2DSP1B		0xF802
#define ARM2DSP1_FLAG 	0xF80C
#define IVPD 0x000049
#define IVPH 0x00004A
#define IER0 0x000000
#define MBX1 5

DEC_CTRL vdec_obj;
volatile int decode_over = 0;
volatile int data_size;
volatile int decode_slice_flag;
volatile int display_flag;
volatile int slice_num;
volatile int is_pslice;

void dsp_announce(uint16 command, uint16 data);

interrupt void
arm2dsp1_isr()
{

    uint16  command;
    uint16  data;
    command = *(ioport uint16 *) ARM2DSP1;
    data = *(ioport uint16 *) ARM2DSP1B;

    switch (command)
    {
    case A2D_INITIALIZE_DEOCDER:
        data_size = (data >> 1) + 1;
        memcpy((uint8 *) bitsteam_internal_address,
               (uint8 *) (Bistream_address + 1), data_size);
        m4v_init_decoder(&vdec_obj, (uint8 *) bitsteam_internal_address, data);
        vdec_obj.image = (uint16 *) FRAME_BUFFER_address;
        vdec_obj.bitstream = (uint8 *) bitsteam_internal_address;
        vdec_obj.stride = vdec_obj.width;
        dsp_announce(D2A_INITIALIZATION_DONE, MBX_NO_DATA);
        break;

    case A2D_INITIALIZE_TASK:
        vdec_obj.length = (data >> 1) + 1;;
        memcpy((uint8 *) bitsteam_internal_address,
               (uint8 *) (Bistream_address + 1), data_size);
        task_initialization(&vdec_obj);
        dsp_announce(D2A_TASK_INITIALIZATION_DONE, MBX_NO_DATA);
        break;

    case A2D_DECODE_SLICE:
    	is_pslice = data >> 8;
    	slice_num = data & 0x00ff;
        decode_slice_flag = 1;
        break;

    case A2D_RELEASE_DECODER:
        decode_over = 1;
        dsp_announce(D2A_RELEASING_DONE, MBX_NO_DATA);
        break;

    case A2D_DISPLAY:
        display_flag = 1;
        break;

    default:
        ;
    }
}

void
install_arm2dsp_isr()
{
    uint32  vector;

    vector = *(ioport uint16 *) ARM2DSP1B;  // clear flag

    asm("	BSET ST1_INTM");
    // install isr
    vector = *(uint16 *) IVPH << 8;
    vector += MBX1 << 3;
    *(uint32 *) (vector / 2) = 0x6A000000 | (uint32) arm2dsp1_isr;
    // enable interrupt
    *(uint16 *) IER0 |= 1 << MBX1;
    asm("	BCLR ST1_INTM");
}
